package IMPL::Text::Parser::Chunk;
use strict;
use warnings;

use base qw(IMPL::Object);

use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

use constant {
    OP_REGEXP => 1,
    OP_STRING => 2,
    OP_REFERENCE => 3,
    OP_CHUNK => 4,
    OP_THROW => 5,
    OP_TRYCATCH => 6
};

BEGIN {
    public _direct property chunkName => prop_get;
    public _direct property opStream => prop_get;
}

sub Regexp {
    my ($this,$rx) = @_;
    
    if (ref $rx eq 'Regexp') {
        
    } elsif (not ref $rx) {
        $rx = q/$rx/;
    } else {
        die new IMPL::InvalidArgumentException('A regular expression required');
    }
    
    push @{$this->{$opStream}}, [OP_REGEXP, $rx];
}

sub String {
    my ($this,$str) = @_;
    
    die new IMPL::InvalidArgumentException("A simple value is required") if ref $str;
    
    push @{$this->{$opStream}}, [OP_STRING, $str];
}

sub Reference {
    my ($this,$ref) = @_;
    
    die new IMPL::InvalidArgumentException("A simple value is reqiured") if ref $ref;
    
    push @{$this->{$opStream}}, [OP_REFERENCE, $ref];
}

sub Chunk {
    my ($this,$chunk) = @_;
    
    die new IMPL::InvalidArgumentException unless UNIVERSAL::isa($chunk,'IMPL::Text::Parser::Chunk');
    
    push @{$this->{$opStream}}, [OP_CHUNK, $chunk];
}

sub Throw {
    my ($this, $msg) = @_;
    
    push @{$this->{$opStream}}, [OP_THROW, $msg];
}

sub TryCatch {
    my ($this,$chunkTry,$chunkCatch) = @_;
    
    push @{$this->{$opStream}}, [OP_TRYCATCH, $chunkTry, $chunkCatch];
}

sub compile {
    my ($this) = @_;
    
    my $text = '';
    
    if ($this->{$opStream}) {
        foreach my $op (@{$this->{$opStream}}) {
            my $code = shift @$op;
            
            if ($code == OP_REGEXP) {
                
            } elsif ($code == OP_STRING) {
                
            } elsif ($code == OP_REFERENCE) {
                
            } elsif ($code == OP_CHUNK) {
                
            } elsif ($code == OP_THROW) {
                
            } elsif ($code == OP_TRYCATCH) {
                
            }
        }
    }
}

1;
