package Test::Resources::Format;
use strict;
use warnings;

use parent qw(IMPL::Test::Unit);
use IMPL::Test qw(test failed);
use IMPL::Resources::Format qw(FormatMessage);

__PACKAGE__->PassThroughArgs;

{
    package Args;
    use parent qw(IMPL::Object);
    
    sub foo {
        return { name => 'Args::foo', value => 'some value'}
    }
}

test FormatMessage => sub {
    my $format = 'This is a %name% message. %args.foo.name% has %args.foo.value% and %some.unknown.param%';
    
    my $args = {
        name => 'Test',
        args => new Args()
    };
    
    my $result = FormatMessage($format,$args);
    my $expected = 'This is a Test message. Args::foo has some value and [some.unknown.param]';
    
    failed
        "Format message returned unexpected results",
        "Expected: $expected",
        "Recieved: $result"
    unless $result eq $expected;
};


1;
