package IMPL::DOM::Node;
use strict;
use warnings;

use base qw(IMPL::Object IMPL::Object::Serializable IMPL::Object::Autofill);

use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use Scalar::Util qw(weaken);

__PACKAGE__->PassThroughArgs;

BEGIN {
    public property nodeName => prop_get | owner_set;
    public property isComplex => prop_get | owner_set;
    public property nodeValue => prop_get | owner_set;
    public property childNodes => prop_get | owner_set| prop_list;
    public property parentNode => prop_get | owner_set;
    private property _propertyMap => prop_all;
}

sub CTOR {
    my $this = @_;
    
    $this->_propertyMap({});
}

sub insertNode {
    my ($this,$node,$pos) = @_;
}

sub removeNode {
    my ($this,$node) = @_;
}

sub removeAt {
    my ($this,$pos) = @_;
}

sub selectNodes {
    my ($this,$name) = @_;
}

sub setParent {
    my ($this,$parentNode) = @_;
}

sub text {
    my ($this) = @_;
}

sub Property {
    my $this = shift;
    my $name = shift;
    
    if (@_) {
        # set
        return $this->_propertyMap->{$name} = shift;
    } else {
        return $this->_propertyMap->{$name};
    }
}

1;
