package IMPL::Test;
use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(&test &shared);

require IMPL::Test::Unit;
use IMPL::Class::Member;

sub test($$) {
    my ($name,$code) = @_;
    my $class = caller;
    
    $class->set_meta(
        new IMPL::Test::Unit::TestInfo( $name, $code )
    );
}

sub shared($) {
    my ($propInfo) = @_;
    
    my $class = caller;
    
    die new IMPL::Exception("Only properties could be declared as shared",$propInfo->Name) unless eval {$propInfo->isa('IMPL::Class::PropertyInfo')};
    die new IMPL::Exception("You can't mark the readonly property as shared",$propInfo->Name) unless $propInfo->canSet;
    die new IMPL::Exception("Only public properties could be declared as shared",$propInfo->Name) unless $propInfo->Access == IMPL::Class::Member::MOD_PUBLIC;
    
    $class->set_meta(new IMPL::Test::Unit::SharedData($propInfo->Name));
}
1;
