package IMPL::Object::Meta;
use strict;
use warnings;

use IMPL::Const qw(:prop);
use IMPL::declare {
    base => [
        'IMPL::Object' => undef
    ],
    props => [
        owner => PROP_RO
    ]
};

sub meta {
    my $class = shift;
    my $caller = caller;
    my $meta = $class->surrogate();
    $meta->owner(scalar caller);
    $meta->callCTOR(@_);
    $caller->SetMeta($meta);
}

1;

__END__

=pod

=head1 SYNOPSIS

package Foo;

meta BarAttribute('Simple bar attribute'); #mark Foo with BarAttribute

=head1 DESCRIPTION

Базовый класс для мета-свойств класса. Определяет оператор C< meta > для создания метаданных в вызвавшем классе.

=head1 MEMBERS

=over

=item C< Container >

Свойство заполняется до вызова конструктора и содержит имя модуля к которому применяется атрибут.

=back

=cut
