package IMPL::Security;
use strict;
use Carp qw(carp);

##VERSION##

require IMPL::Exception;
require IMPL::Security::Rule::RoleCheck;

use IMPL::require { 
    Principal => 'IMPL::Security::Principal',
    AbstractContext => 'IMPL::Security::AbstractContext',
    Context => 'IMPL::Security::Context'
};

sub principal {
    return
        AbstractContext->current
        && AbstractContext->current->principal
        || Principal->nobody; 
}

sub context {
    AbstractContext->current || Context->nobody;
}

1;

__END__