package IMPL::AppException;
use strict;
use mro 'c3';
use overload
    '""' => 'ToString',
    'bool'     =>   sub { return 1; },
    'fallback' => 1;

use Carp qw(longmess shortmess);
use Scalar::Util qw(refaddr);

use IMPL::Const qw(:prop);
use IMPL::Resources::Strings {
	messageFormat => "Application exception"
};

use IMPL::declare {
    base => [
        'IMPL::Object' => '@_'
    ],
    props => [
        source => PROP_RO,
        callStack => PROP_RO,
        _cachedMessage => PROP_RW 
    ]
};

sub new {
	my $self = shift;
	local $Carp::CarpLevel = 0;
	
	my $instance = $self->next::method(@_);
    
    $instance->callStack(longmess);
    $instance->source(shortmess);
    
    return $instance;
}


sub message {
	my ($this) = @_;
	
	if (my $msg = $this->_cachedMessage) {
		return $msg;
	} else {
	   my $formatter = $this->can('messageFormat');
	   return $this->_cachedMessage($formatter->($this));
	}
}

sub ToString {
	my ($this) = @_;
	
	return join("\n", $this->message, $this->callStack);
}

1;