package IMPL::Const;
use strict;

use parent qw(Exporter);

our %EXPORT_TAGS = (
    all => [
        qw(
          &ACCESS_PUBLIC
          &ACCESS_PROTECTED
          &ACCESS_PRIVATE
          &PROP_GET
          &PROP_SET
          &PROP_OWNERSET
          &PROP_LIST
          &PROP_ALL
          )
    ],
    prop => [
        qw(
          &PROP_GET
          &PROP_SET
          &PROP_OWNERSET
          &PROP_LIST
          &PROP_ALL
          &PROP_RO
          &PROP_RW
          )
    ],
    access => [
        qw(
          &ACCESS_PUBLIC
          &ACCESS_PROTECTED
          &ACCESS_PRIVATE
          )
    ]
    
);

our @EXPORT_OK = keys %{ { map (($_,1) , map (@{$_}, values %EXPORT_TAGS) ) } };

use constant {
    ACCESS_PUBLIC    => 1,
    ACCESS_PROTECTED => 2,
    ACCESS_PRIVATE   => 3,
    PROP_GET         => 1,
    PROP_SET         => 2,
    PROP_OWNERSET    => 10,
    PROP_LIST        => 4,
    PROP_ALL         => 3,
    PROP_RW          => 3,
    PROP_RO          => 11
};

1;