package Schema::Form::Format;
use strict;
use Common;
our @ISA = qw(Object);

BEGIN {
    DeclareProperty Name => ACCESS_READ;
    DeclareProperty Filters => ACCESS_READ;
    DeclareProperty Attributes => ACCESS_READ;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$Name} = $args{'Name'} or die new Exception('A format name is required');
    $this->{$Filters} = [];
    $this->{$Attributes} = $args{'Attributes'} || {};
}

sub AddFilter {
    my ($this,$filter) = @_;
    
    push @{$this->{$Filters}},$filter;
}

1;
