package IMPL::Config::Activator;
use strict;

use base qw(IMPL::Object IMPL::Object::Autofill);
use IMPL::Class::Property;

BEGIN {
	public property factory => prop_all;
	public property args => prop_all;
	private property _object => prop_all;
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    die new IMPL::Exception("A Type parameter is required") unless $this->Type;
    
}

sub _is_class {
    no strict 'refs';
    scalar keys %{"$_[0]::"} ? 1 : 0;
}

sub instance {
    my $this = shift;
    
    my $factory = $this->fatory;
    
    if (my $obj = $this->_object) {
        return $obj;
    } else {
        my %args = (%{$this->args || {}},@_);
        eval "require $factory" unless not ref $factory and _is_class($factory);
        my $inst = $factory->new(%args);
        $this->_object($inst);
        return $inst;
    }
}

1;