package IMPL::Web::Application;
use strict;
use warnings;

use base qw(IMPL::Object IMPL::Object::Singleton);

require IMPL::Web::Application::Action;
require IMPL::Web::Application::Response;

use IMPL::Class::Property;
use CGI;

BEGIN {
    public property handlerError => prop_all;
    public property factoryAction => prop_all;
    public property handlersQuery => prop_all | prop_list;
}

# custom factory
sub new {
    my ($self,$file) = @_;
    
    return $self->LoadXMLFile($file);
}

sub Run {
    my ($this) = @_;
    
    while (my $query = $this->FetchRequest()) {
        my $response = new IMPL::Web::Application::Response(request => $query);
        
        my $action = new IMPL::Web::Application::Action(
        	request => $query,
        	response => $response,
        	application => $this, 
        ); 
        
        $action->ChainHandler($_) foreach $this->handlersQuery;
        
        $action->Invoke();
    }
}

{
	my $hasFetched = 0;

	sub FetchRequest {
		return undef if $hasFetched;
		$hasFetched = 1;
		return CGI->new();
	}
}

1;

__END__

=pod

=head1 SYNOPSIS

require MyApp;
MyApp->spawn('app.config')->Run();

=head1 DESCRIPTION

      ,   ,
     CGI    .

      

1.  cgi 
2.      
3.    
4.  
5.      




=cut
