package IMPL::Web::Application::Action;
use strict;

use base qw(IMPL::Object);

use IMPL::Class::Property;

BEGIN {
	public property application => prop_get | owner_set;
	public property request => prop_get | owner_set;
	public property response => prop_get | owner_set;
	
	private property _entryPoint => prop_all;
}

sub Invoke {
	my ($this) = @_;
	
	if ($this->_entryPoint) {
		$this->_entryPoint->();
	} else {
		die new IMPL::InvalidOperationException("At least one handler is required");
	}
}

sub ChainHandler {
	my ($this,$handler) = @_;
	
	my $delegateNext = $this->_entryPoint();
	
	if (ref $handler eq 'CODE') {
		$this->_entryPoint( sub {
			$handler->($this,$delegateNext);			
		} );
	} elsif (UNIVERSAL::isa($handler,'IMPL::Web::Application::QueryHandler')) {
		$this->_entryPoint( sub {
			$handler->Invoke($this,$delegateNext);
		} );
	} elsif ($handler and not ref $handler) {
		my $method = $this->can($handler) or die new IMPL::InvalidArgumentException("An invalid handler supplied");
		
		$this->_entryPoint( sub {
			$method->($this,$delegateNext);			
		} );
	} else {
		die new IMPL::InvalidArgumentException("An invalid handler supplied");
	}
	
}

1;

__END__

=pod

=head1 DESCRIPTION

   .

     ,   
  .

    ,   

SecCallToMethod($target,$method)
AuthenticateMethod
TDocumentOut($file)

    

Action->Invoke() {
	TDocumentOut->Invoke($Action,$nextHandler) {
		my $result = $nextHandler() {
			$AuthenticateMethod($Action,$nextHandler) {
				my $context = $Action->application->security->Authenticate($Action->request,$Action->response);
				return $context->Impersonate($nextHandler) {
					$objSecCallToMethod->Invoke($Action,undef) {
						IMPL::Security->AccessCheck($target,$method);
						return $target->$method();
					}
				}
			}
		}
		$this->format($result,$Action->response->streamBody);
	}		
}

     

$objSecCallToMethod($target,$method)
$AuthenticateMethod
$TransfromToSimpleData
$JSONOut

      ,     
     JSON .    
     ,     .

=head1 HANDLERS

=head2 subroutines

=over

=item CODE ref

     ,      
 :   action ,     .

=item Method Name

 ,    .    action   
 ,           
:   action ,     .

    C<< $action->MethodName($nextHandler) >>; 

=back 

=head2 C< IMPL::Web::Application::QueryHandler >

    C< IMPL::Web::Application::QueryHandler >  
    

=cut