package IMPL::Web::Application::Session;
use strict;

use base qw(IMPL::Object);

use IMPL::Security::Auth qw(GenSSID);

use IMPL::Class::Property;

BEGIN {
	public property id => prop_get | owner_set;
	public property principal => prop_get | owner_set;
	public property authSession => prop_get | owner_set;
	public property roles => prop_get | owner_set | prop_list;
}

sub CTOR {
	my ($this,%args) = @_;
	
	$this->principal($args{principal}) or die new IMPL::InvalidArgumentException("A principal is required");
	$this->authSession($args{auth}) or die new IMPL::InvalidArgumentException("An auth session is required");
	$this->roles($args{roles}) if $args{roles};
	
	$this->id(GenSSID());
}

sub DoAuth {
	my ($this,$secData) = @_;
	
	return $this->authSession->DoAuth($secData);
}

sub ValidateSession {
	my ($this,$secData) = @_;
	
	return $this->authSession->ValidateSession($secData);
}

1;

__END__