package IMPL::Class::Template;
use strict;
use IMPL::lang;
use IMPL::_core::version;

sub makeName {
    my ($class,@params) = @_;
    
    $_ =~ s/^.*::(\w+)$/$1/ foreach @params;
    return join('',$class,@params);
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Class::Template> базовый класс для шаблонов.

=head1 SYNPOSIS

=begin code

package KeyValuePair;

use IMPL::Class::Property;

use IMPL::template (
    parameters => [qw(TKey TValue))],
    base => [qw(IMPL::Object IMPL::Object::Autofill)],
    declare => sub {
        my ($class) = @_;
        public $class->CreateProperty(key => prop_get | owner_set, { type => $class->TKey } );
        public $class->CreateProperty(value => prop_all, { type => $class->TValue} );
        
        $class->PassThroughArgs;
    }
);

BEGIN {
    public property id => prop_get | owner_set, { type => 'integer'};
}

__PACKAGE__->PassThroughArgs;

package MyCollection;

use IMPL::Class::Property;

use IMPL::lang;
use IMPL::template(
    parameters => [qw(TKey TValue)],
    base => [qw(IMPL::Object)],
    declare => sub {
        my ($class) = @_;
        my $item_t = spec KeyValuePair($class->TKey,$class->TValue);
        
        public $class->CreateProperty(items => prop_get | prop_list, { type => $item_t } )
        
        $class->static_accessor( ItemType => $item_t );
    }
)

sub Add {
    my ($this,$key,$value) = @_;
    
    die new IMPL::ArgumentException( key => "Invalid argument type" ) unless is $key, $this->TKey;
    die new IMPL::ArgumentException( value => "Invalid argument type" ) unless is $value, $this->TValue;
    
    $this->items->AddLast( $this->ItemType->new( key => $key, value => $value ) );
}

=end code

=head1 DESCRIPTION

Шаблоны используются для динамической генерации классов. Процесс создания класса
по шаблону называется специализацией, при этом создается новый класс:

=over 

=item 1

Обявляется новый пакет с именем, вычисленным из имени и параметров шаблона

=item 2

Формируется массив C<@ISA> для созаднного класса, в который добавляется имя шаблона

=item 3

Формируются методы с именами параметров шаблона, возвращающие реальные значения параметров

=item 4

Вызывается метод для конструирования специализиции 

=back

=head1 MEMBERS

=over

=item C<spec(@params)>

Метод, создающий специализацию шаблона. Может быть вызван как оператор. 

=back

=cut
