package IMPL::Web::View::TTDocument;
use strict;

use Scalar::Util qw(weaken);
use IMPL::Const qw(:prop);
use IMPL::lang qw(:hash is);
use Carp qw(carp);
use mro;
use IMPL::Exception();
use IMPL::declare {
    require => {
    	TTRegistry => 'IMPL::Web::View::TTRegistry',
        TTFactory => 'IMPL::Web::View::TTFactory',
        TTControl =>  'IMPL::Web::View::TTControl',
        Loader => 'IMPL::Code::Loader',
        OpException => '-IMPL::InvalidOperationException'
    },
    base => [
        'IMPL::Web::View::TTControl' => sub {
            my ($template,$ctx,$vars) = @_;
            $ctx ||= Template::Context->new();
            return $template, $ctx, $vars;  # context
        }
    ],
    props => [
        layout => PROP_RW,
        layoutBase => PROP_RW,
        registry => PROP_RW,
        baseLocation => PROP_RW
    ]
};

sub CTOR {
    my ($this,$template,$ctx) = @_;
    
    $this->layout( $template->layout ) unless $this->layout;
    $this->title( $template->title ) unless $this->title;
    my $doc = $this;
    weaken($doc);
    $this->registry->context->stash->update({
        document => sub { $doc }
    });
}

sub Render {
    my ($this,$args) = @_;

    $args ||= {};
    $args->{document} = $this;
    
    
    if ($this->layout) {
    	my $layout = $this->registry->Require(join('/',$this->layoutBase, $this->layout))->new();
    	
    	my $next = $this->next::can();
    	
    	return $layout->Render({
            content => sub { $this->$next($args) },
            template => $this->template,
            document => $this
        });
    } else {
        return $this->next::method($args);
    }
}

sub GetTemplate {
    my ($this,$name) = @_;
    
    $this->template->blocks->{$name};
}

sub DTOR {
	my $this = shift;
	
	$this->registry->Dispose() if $this->registry;
}

sub _clone_context {
    my $args = { %{shift || {}} };
    delete $args->{CONFIG};
    
    return Template::Context->new($args);
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::View::TTDocument> - документ для построения HTML страницы на основе шаблонов TT.

=head1 SYNOPSIS

=begin code


=end code

=head1 DESCRIPTION


=over


=cut