use strict;
package IMPL::SQL::Schema::Column;
use parent qw(IMPL::Object IMPL::Object::Autofill);

use IMPL::lang qw( :DEFAULT :compare :declare :hash );
use IMPL::Class::Property::Direct;
use IMPL::Exception();

BEGIN {
    public _direct property name => PROP_GET;
    public _direct property type => PROP_GET;
    public _direct property isNullable => PROP_GET;
    public _direct property defaultValue => PROP_GET;
    public _direct property tag => PROP_GET;
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    $this->{$name} or
        die new IMPL::InvalidArgumentException('A column name is required');
    
    $this->{$isNullable} = 0 if not exists $this->{$isNullable};
    
    is( $this->{$type}, typeof IMPL::SQL::Schema::Type) or
        die new IMPL::InvalidArgumentException('a type is required for the column',$this->{$name});
}

sub SameValue {
    my ($this,$other) = @_;
    
    return (
        $this->{$name} eq $other->{$name}
        and $this->{$isNullable} == $other->{$isNullable}
        and equals_s($this->{$defaultValue}, $other->{$defaultValue})
        and $this->{$type}->SameValue($other->{$type})
    );
}

sub SetType {
    my ($this,$newType) = @_;
    
    $this->{$type} = $newType;
}

sub SetDefaultValue {
    my ($this,$value) = @_;
    
    $this->{$defaultValue} = $value;
}

sub SetNullable {
    my ($this, $value) = @_;
    
    $this->{$isNullable} = $value;
}

sub SetOptions {
    my ($this,$diff) = @_;
    
    return unless ref $diff eq 'HASH';
    
    $this->tag({}) unless $this->tag;
    
    hashApply($this->tag,$diff);
}

1; 
