package IMPL::Web::Application::Action;

use base qw(IMPL::Object);

use IMPL::Class::Property;

BEGIN {
	public property application => prop_get | owner_set;
	public property request => prop_get | owner_set;
	public property response => prop_get | owner_set;
	public property code => prop_get | owner_set;
	public property chainHandlers => prop_get | owner_set | prop_list;
}

1;

__END__

=pod

=head1 DESCRIPTION

   ,  ,  .

   ,   C<IMPL::Web::Application::UriController>.
     ,       ,
             ,
   .

    ,   

$objSecCallToMethod($target,$method)
$AuthenticateMethod
$TDocumentOut($file)

    

Action->Invoke() {
	TDocumentOut->Invoke($Action,$nextHandler) {
		my $result = $nextHandler() {
			$AuthenticateMethod($Action,$nextHandler) {
				my $context = $Action->application->security->Authenticate($Action->request,$Action->response);
				return $context->Impersonate($nextHandler) {
					$objSecCallToMethod->Invoke($Action,undef) {
						IMPL::Security->AccessCheck($target,$method);
						return $target->$method();
					}
				}
			}
		}
		$this->format($result,$Action->response->streamBody);
	}		
}

     

$objSecCallToMethod($target,$method)
$AuthenticateMethod
$TransfromToSimpleData
$JSONOut

      ,     
     JSON .    
     ,     .

=cut