package IMPL::Object::Disposable;
use strict;

our $Strict = 1;

sub Dispose {
    my ($this) = @_;

    bless $this, 'IMPL::Object::Disposed';
}

sub DTOR {
    my ($this) = @_;

    warn sprintf('The object %s were marked as disposable but isn\'t disposed properly', $this->can('ToString') ? $this->ToString() : (ref $this || $this) );
}

sub superDispose {
    my ($this) = @_;

    my $package = caller;

    no strict 'refs';

    ($_.'::Dispose')->($this) foreach @{$package.'::ISA'};
}

package IMPL::Object::Disposed;
our $AUTOLOAD;
sub AUTOLOAD {
    return if $AUTOLOAD eq __PACKAGE__.'::DESTROY';
    die new IMPL::Exception('Object have been disposed',$AUTOLOAD);
}

sub isDisposed {
    1;
}

1;
