package IMPL::Object::InlineFactory;
use strict;
use Carp qw(croak);

sub new {
	my $self = shift;
	if(ref $self) {
		return &$$self(@_);
	} else {
		my $factory = shift;
		
		croak "A code reference is required"
		  unless ref $factory eq 'CODE';
		
		return bless \$factory, $self;
	}
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Object::InlineFactory> - реализация фабрики на основе процедуры.

=head1 SYNOPSIS

=begin code

use IMPL::require {
	InlineFactory => 'IMPL::Object::InlineFactory',
	Foo => 'My::App::Foo'
};

my $factory = InlineFactory->new(sub { Foo->new(mode => 'direct', @_) });

my $obj = $factory->new(timeout => 10); # Foo->new(mode => 'direct', timeout => 10);

=end code

=cut