package IMPL::Config::Activator;
use strict;

use Scalar::Util qw(reftype);
use IMPL::lang;
use IMPL::Const qw(:prop);
use IMPL::declare {
	require => [
	   Loader => 'IMPL::Code::Loader',
	   Exception => 'IMPL::Exception'
	],
	base => [
	   'IMPL::Object' => undef,
	   'IMPL::Object::Autofill' => '@_',
	   'IMPL::Object::PublicSerializable' => undef
	],
	props => [
	   factory => PROP_RW,
	   parameters => PROP_RW,
	   object => PROP_RO
	]
};

use constant {
	SELF_CLASS => __PACKAGE__
};

sub CTOR {
    my $this = shift;

    die Exception->new("A factory parameter is required") unless $this->factory;
    
}


sub activate {
    my $this = shift;
    
    unless ($this->object) {
        my @args;
        
        my $params = $this->parameters;
        if (reftype($params) eq 'HASH') {
            while ( my ($key,$value) = each %$params ) {
                push @args,$key, is($value,SELF_CLASS) ? $value->activate : $value;
            }
        } elsif (reftype($params) eq 'ARRAY') {
            push @args, map is($_,SELF_CLASS) ? $_->activate : $_, @$params;
        } else {
            push @args, is($params,SELF_CLASS) ? $params->activate : $params;
        }
        
        push @args,  map is($_,SELF_CLASS) ? $_->activate : $_, @_ if @_;
        
        my $factory = $this->factory;
        Loader->Require($factory) unless ref $factory;
        
        return $this->object($factory->new(@args));
    } else {
        return $this->object;
    }
}

1;

__END__

=pod

=head1 NAME

C<>

=cut
