package IMPL::DOM::Node;
use strict;
use warnings;

use base qw(IMPL::Object);

use IMPL::Object::List;
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use Scalar::Util qw(weaken);

use IMPL::Exception;

BEGIN {
    public _direct property nodeName => prop_get | owner_set;
    public _direct property isComplex => { get => \&_getIsComplex } ;
    public _direct property nodeValue => prop_all;
    public _direct property childNodes => { get => \&_getChildNodes };
    public _direct property parentNode => prop_get ;
    private _direct property _propertyMap => prop_get ;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->nodeName($args{nodeName}) or die new IMPL::InvalidArgumentException("A name is required");
}

sub insertNode {
    my ($this,$node,$pos) = @_;
    
    die new IMPL::InvalidOperationException("You can't insert the node to itselft") if $this == $node;
    
    $node->{$parentNode}->removeNode($node) if ($node->{$parentNode});
    
    $this->childNodes->InsertAt($pos,$node);
    
    $node->_setParent( $this );
    
    return $node;
}

sub appendNode {
    my ($this,$node,$pos) = @_;
    
    die new IMPL::InvalidOperationException("You can't insert the node to itselft") if $this == $node;
    
    $node->{$parentNode}->removeNode($node) if ($node->{$parentNode});
    
    $this->childNodes->Append($node);
    
    $node->_setParent( $this );
    
    return $node;
}

sub _getChildNodes {
    my ($this) = @_;
    
    $this->{$childNodes} = new IMPL::Object::List() unless $this->{$childNodes};
    $this->{$childNodes};
}

sub removeNode {
    my ($this,$node) = @_;
    
    if ($this == $node->{$parentNode}) {
        $this->childNodes->RemoveItem($node);
        $node->{$parentNode} = undef;
        return $this;
    } else {
        die new IMPL::InvalidOperationException("The specified node isn't belong to this node");
    }
}

sub replaceNodeAt {
    my ($this,$index,$node) = @_;
    
    my $nodeOld = $this->childNodes->[$index];
        
    die new IMPL::InvalidOperationException("You can't insert the node to itselft") if $this == $node;
        
    # unlink node from previous parent
    $node->{$parentNode}->removeNode($node) if ($node->{$parentNode});
        
    # replace (or set) old node
    $this->childNodes->[$index] = $node;
        
    # save new parent
    $node->_setParent( $this );
        
    # unlink old node if we have one
    $nodeOld->{$parentNode} = undef if $nodeOld;
        
    # return old node
    return $nodeOld;
}

sub removeAt {
    my ($this,$pos) = @_;
    
    if ( my $node = $this->childNodes->RemoveAt($pos) ) {
        $node->{$parentNode} = undef;
        return $node;
    } else {
        return undef;
    }
}

sub selectNodes {
    my ($this,$query) = @_;
    my @result;
    
    if (ref $query eq 'CODE') {
        @result = grep &$query($_), @{$this->childNodes};
    } else {
        @result = grep $_->nodeName eq $query, @{$this->childNodes};
    }
    
    return wantarray ? @result : \@result;
}

sub firstChild {
    @_ >=2 ? $_[0]->replaceNodeAt(0,$_[1]) : $_[0]->childNodes->[0];
}

sub _getIsComplex {
    $_[0]->childNodes->Count ? 1 : 0;
}

sub _setParent {
    my ($this,$node) = @_;
    
    $this->{$parentNode} = $node;
    # prevent from creating cyclicreferences
    weaken($this->{$parentNode});
}

sub text {
    my ($this) = @_;
    
    join '', $this->nodeValue, map $_->nodeValue, @{$this->childNodes};
}

sub Property {
    my $this = shift;
    my $name = shift;
    
    if (@_) {
        # set
        return $this->{$_propertyMap}{$name} = shift;
    } else {
        return $this->{$_propertyMap}{$name};
    }
}

1;
