package IMPL::Web::Application;
use strict;
use warnings;

use base qw(IMPL::Object IMPL::Object::Singleton);
use IMPL::Class::Property;

BEGIN {
    public property RequestFactory => prop_all;
    public property ContextInitializers => prop_all;
}

# custom factory
sub new {
    my ($self,$file) = @_;
    
    return $self->LoadXMLFile($file);
}

sub Run {
    my ($this) = @_;
    
    while (my $request = $this->fetch_request()) {
        my $context = $this->prepare_context($request);
        $context->invoke($request);
    }
}

1;

=pod

=head1 SYNOPSIS

require MyApp;
MyApp->instance('app.config')->Run();

=head1 DESCRIPTION

      ,   ,

    ,    
     .

    ,     

=cut
