package IMPL::Class::Property;
use strict;
use base qw(Exporter);
BEGIN {
    our @EXPORT = qw(property prop_get prop_set owner_set prop_none prop_all prop_list CreateProperty);
}

require IMPL::Class::Member;
require IMPL::Class::PropertyInfo;

sub import {
    __PACKAGE__->export_to_level(1,@_);
    IMPL::Class::Member->export_to_level(1,@_);
}

sub prop_get { 1 };
sub prop_set { 2 };
sub owner_set { 10 };
sub prop_none { 0 };
sub prop_all { 3 };
sub prop_list { 4 };

sub property($$;$) {
    my ($propName,$mutators,$attributes) = @_;
    my $Info = new IMPL::Class::PropertyInfo( {Name => $propName, Mutators => $mutators, Class => scalar(caller), Attributes => $attributes } );
    return $Info;
}

sub CreateProperty {
    my ($class,$propName,$mutators,$attributes) = @_;
    my $Info = new IMPL::Class::PropertyInfo( {Name => $propName, Mutators => $mutators, Class => $class, Attributes => $attributes} );
    return $Info;
};

1;
