package IMPL::DOM::Schema::Validator::RegExp;

use base qw(IMPL::DOM::Schema::Validator);

our %CTOR = (
	'IMPL::DOM::Schema::Validator' => sub {
		my %args = @_;
		$args{nodeName} ||= 'RegExp';
		%args;
	}
);

use IMPL::Class::Property;

BEGIN {
	public property message => prop_all;
}

sub CTOR {
	my ($this,%args) = @_;
	
	$this->message($args{message} || "A %Node.nodeName% doesn't match to the format %Schema.display%");
}

sub Validate {
	my ($this,$node,$ctx) = @_;
	
	my $rx = $this->nodeValue;
	return new IMPL::DOM::Schema::ValidationError(
		Node => $node,
		Source => $ctx && $ctx->{Source} || $this->parentNode,
		Schema => $this->parentNode,
		Message => $this->message
	) unless (not $node->isComplex) and $node->nodeValue =~ /$rx/;
	return ();
}

1;