package IMPL::Web::TT::Control;

use base qw(IMPL::Web::TT::Collection);

use IMPL::Class::Property;

__PACKAGE__->PassThroughArgs;

BEGIN {
	public property controlClass => prop_all;
	public property template => prop_all;
	public property id => prop_all;
}

my $nextId = 1;

sub CTOR {
	my ($this,%args) = @_;
	
	if ($this->document) {
		# load a template
		#$args{template} = $this->document->context->template($args{template}) if ($args{template});
	}
	$this->template($args{template}) if $args{template};

	$this->id($this->nodeName . '-' . $nextId++);
	$this->controlClass($args{controlClass} || 'Control');
}

sub Render {
	my ($this) = @_;
	
	if ($this->document) {
		if ($this->template) {
			return $this->document->context->include($this->template,{ this => $this });
		} elsif ($this->document->presenter) {
			return $this->document->presenter->print($this);
		} else {
			return $this->toString();
		}
	}
}

1;