package Configuration;
our $HtDocsDir;

package Engine;
our $Encoding;

package Engine::Output::JSON;
use strict;
use warnings;

use Encode;
use PerlIO;
use IMPL::Exception;
use JSON;

sub CTX_TEMPLATE()  { 1 }
sub CTX_DATA()      { 2 }

my $context = CTX_DATA;
our $Data;

sub template() { $context = CTX_TEMPLATE }
sub data() { $context = CTX_DATA }

sub Print {
    my ($class,$query,$action) = @_;
    
    my @path = $action->RequestURI->path_segments;
    shift @path;
    
    my $result;
    
    undef $@;
    $Data = $action->Result;
    eval {
        my $fname = $HtDocsDir . join '/', @path;
        if ($context == CTX_DATA) {
            my $dummy = '';
            open my $hstd, ">>", \$dummy or die new IMPL::Exception('Failed to create inmemory stream');
            local (*STDIN,*STDOUT) = ($hstd,$hstd);
            local ${^ENCODING};
            $result = do $fname or die new IMPL::Exception('Failed to evalute the file', $@, $!,$fname);
        } else {
            die new IMPL::Exception('JSON templates not implemented');
        }
    };
    if ($@) {
        $result = { errorCode => 1, errorMessage => "$@"};
    }
    
    print $query->header(-status => 200, -type => 'text/javascript');
    print to_json({ errorCode => 0, result => $result });
}


1;
