package IMPL::DOM::Schema::NodeList;
use strict;
use warnings;
use base qw(IMPL::DOM::Node);

use IMPL::Class::Property;
require IMPL::DOM::Schema::ValidationError;

our %CTOR = (
    'IMPL::DOM::Node' => sub { nodeName => 'NodeList' }
);

BEGIN {
    public property messageUnexpected => prop_all;
    public property messageNodesRequired => prop_all;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->messageUnexpected($args{messageUnexpected} || 'A %Node.nodeName% isn\'t allowed here');
    $this->messageNodesRequired($args{messageNodesRequired} || 'A content of the node %Node.nodeName% is incomplete');
}

sub Validate {
    my ($this,$node) = @_;
    
    my @nodes = map {
        {nodeName => $_->nodeName, anyNode => $_->isa('IMPL::DOM::Schema::AnyNode') , Schema => $_, Min => $_->minOccur eq 'unbounded' ? undef : $_->maxOccur, Max => $_->maxOccur, Seen => 0 }
    } @{$this->childNodes};
    
    my $info = shift @nodes;
    
    foreach my $child ( @{$node->childNodes} ) {
        #skip schema elements
        while ($info and not $info->{anyNode} and $info->{nodeName} ne $child->nodeName) {
            # if possible of course :)
            return new IMPL::DOM::Schema::VaidationError (
                Message => $this->messageUnexpected,
                Node => $child,
                Schema => $info->{Schema},
                Source => $this
            ) if $info->{Min} > $info->{Seen};
            
            $info = shift @nodes;
        }
        
        # return error if no more children allowed
        return new IMPL::DOM::Schema::VaidationError (
            Message => $this->messageUnexpected,
            Node => $child,
            Source => $this
        ) unless $info;
        
        # it's ok, we found schema element for him
        $info->{Seen}++;
        
        # check count limits
        return new IMPL::DOM::Schema::VaidationError (
            Error => 1,
            Message => $this->messageUnexpected,
            Node => $child,
            Source => $this,
        ) if $info->{Max} and $info->{Seen} > $info->{Max};
        
        # validate
        if (my @errors = $info->{Schema}->Validate($child)) {
            return @errors;
        }
    }
    
    # no more children left (but may be should :)
    while ($info) {
        return new IMPL::DOM::Schema::VaidationError (
            Error => 1,
            Message => $this->messageNodesRequired,
            Node => $node,
            Source => $this
        ) if $info->{Seen} < $info->{Min};
        
        $info = shift @nodes;
    }
}

1;

__END__

=pod

=head1 DESCRIPTION

   .  .    
 C<IMPL::DOM::Schema::ComplexNode>  C<IMPL::DOM::Schema::SimpleNode>.

=cut