package IMPL::Test::BadUnit;
use strict;
use warnings;

use base qw(IMPL::Test::Unit);
use IMPL::Class::Property;

BEGIN {
    public property UnitName => prop_all;
    public property Message => prop_all;
    public property Error => prop_all;
}

our %CTOR = (
    'IMPL::Test::Unit' => sub {
        my ($unit,$message,$error) = @_;
        return new IMPL::Test::Unit::TestInfo(
            BadUnitTest => sub {
                die new IMPL::Test::FailException($message,$unit,eval {$error->isa('IMPL::Exception')} ? $error->toString(1) : $error)
            }
        );
    }
);

sub CTOR {
    my ($this,$name,$message,$error) = @_;
    
    $this->UnitName($name);
    $this->Message($message);
    $this->Error($error);
}

sub save {
    my ($this,$ctx) = @_;
    
    defined ($this->$_()) and $ctx->AddVar($_ => $this->$_()) foreach qw(UnitName Message);
}

sub restore {
    my ($class,$data,$inst) = @_;
    
    my %args = @$data;
    
    $inst ||= $class->surrogate;
    $inst->callCTOR(@args{qw(UnitName Message)});
}


1;
