package IMPL::Web::TT::Collection;
use strict;

use base qw(IMPL::DOM::Node);

__PACKAGE__->PassThroughArgs;

our $AUTOLOAD;
sub AUTOLOAD {
	my $this = shift;
	my ($method) = ($AUTOLOAD =~ /(\w+)$/);
	
	return if $method eq 'DESTROY';
	
	if ( @_ >= 1 ) {
		# set
		
		if ($method =~ /^add(\w+)/) {
			my ($name,$args) = @_;
			return $this->appendChild($this->document->CreateControl($name,$1,$args));
		}
		
		# we can't assing a node, so this is a dynamic property
		return $this->nodeProperty($method,@_);
	} else {
		# get
		# try a dynamic property first 
		if ( my $val = $this->nodeProperty($method) ) {
			return $val;
		} else {
		# and return a first child node as last opportunity
			my @result = $this->selectNodes($method);
	
			return $result[0] if @result;
		}
	}
	
	return;
}

sub as_list {
	$_[0]->childNodes;
}

1;