package IMPL::Object::Disposable;
use strict;
require IMPL::Object::AutoDispose;

our $Strict = 1;

sub Dispose {
    my ($this) = @_;

    bless $this, 'IMPL::Object::Disposed';
}

sub DTOR {
    my ($this) = @_;

    warn sprintf('The object %s were marked as disposable but isn\'t disposed properly', $this->can('ToString') ? $this->ToString() : (ref $this || $this) );
}

sub AutoPtr {
    IMPL::Object::AutoDispose->new(shift);
}

package IMPL::Object::Disposed;
our $AUTOLOAD;
sub AUTOLOAD {
    return if $AUTOLOAD eq __PACKAGE__.'::DESTROY';
    die new IMPL::Exception('Object have been disposed',$AUTOLOAD);
}

sub isDisposed {
    1;
}

1;
