package IMPL::SQL::Schema::Constraint;
use strict;
use warnings;

use IMPL::lang qw(:declare :constants is);

use parent qw(IMPL::Object IMPL::Object::Disposable);

use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property name => PROP_GET;
    public _direct property table => PROP_GET;
}

public property columns => PROP_GET | PROP_LIST | PROP_OWNERSET;

sub CTOR {
    my ($this,%args) = @_;
    is( $args{table}, typeof IMPL::SQL::Schema::Table ) or
    	die new IMPL::InvalidArgumentException("table argument must be a table object");
    $this->{$name} = $args{'name'};
    $this->{$table} = $args{'table'};
    $this->columns( [map { ResolveColumn($this->table,$_) } @{$args{'columns'}}] );
}

sub ResolveColumn {
    my ($Table,$Column) = @_;
    
    my $cn = UNIVERSAL::isa($Column,'IMPL::SQL::Schema::Column') ? $Column->name : $Column;
    
    my $resolved = $Table->Column($cn);
    die new IMPL::InvalidOperationException("The column is not found in the table", $cn, $Table->name) if not $resolved;
    return $resolved;
}

sub HasColumn {
    my ($this,@Columns) = @_;
    
    my %Columns = map { $_, 1} @Columns;
    
    return scalar(grep { $Columns{$_->name} } @{$this->columns}) == scalar(@Columns);
}

sub uniqName {
    my ($this) = @_;
    return $this->{$table}->name.'_'.$this->{$name};
}

sub Dispose {
    my ($this) = @_;
    
    $this->columns([]);
    
    delete $$this{$table};
    
    $this->SUPER::Dispose;
}

sub SameValue {
	my ($this,$other) = @_;
			
	return 0 unless $this->columns->Count == $other->columns->Count;
	
	for ( my $i=0; $i < $this->columns->Count; $i++ ) {
		return 0 unless $this->columns->[$i]->name eq $other->columns->[$i]->name;
	}
	
	return 1;
}
1;
