use strict;
package Deployment::Batch::CustomAction;
use parent qw(Deployment::Batch::Generic);
use Common;

BEGIN {
    DeclareProperty handlerRun => ACCESS_READ;
    DeclareProperty handlerRollback => ACCESS_READ;
    DeclareProperty Name => ACCESS_READ;
}

sub CTOR {
    my ($this,%args) = @_;

    $this->{$handlerRun} = $args{Run} || sub {};
    $this->{$handlerRollback} = $args{Rollback} || sub {};
    $this->{$Name} = $args{Name} || $this->SUPER::Name();
}

sub Run {
    my ($this) = @_;

    $this->{$handlerRun}->($this);
}

sub Rollback {
    my ($this) = @_;

    $this->{$handlerRollback}->($this);
}

1;
