package Test::Web::View;
use strict;
use warnings;

use parent qw(IMPL::Test::Unit);
__PACKAGE__->PassThroughArgs;

use IMPL::Test qw(assert test);
use IMPL::Web::View::TTLoader();

use constant {
	TTLoader => typeof IMPL::Web::View::TTLoader
};

test TemplateLoaderTests => sub {
	my ($this) = @_;
	
	my $loader = TTLoader->new(
		{
			INCLUDE_PATH => [
				$this->GetResourceDir('Resources')
			]
		},
		ext => '.tt'
	);
	
	assert( defined(my $tt = $loader->template('simple') ) );
	
	$tt;	
};

1;