package IMPL::Web::View::TTView;
use strict;

use IMPL::lang qw(hashMerge);
use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Context => 'IMPL::Web::View::TTContext'
	},
	base => [
		'IMPL::Object' => undef,
		'IMPL::Object::Autofill' => '@_',
		'IMPL::Object::Serializable' => undef
	],
	props => [
		options => PROP_RW,
		viewBase => PROP_RW,
		layoutBase => PROP_RW,
		layout => PROP_RW,
		tt_ext => PROP_RW,
		includes => PROP_RW | PROP_LIST,
		globals => PROP_RW
	]
};

sub CTOR {
	my ($this) = @_;
	
	$this->tt_ext('tt') unless defined $this->tt_ext;
}

sub display {
	my ($this,$model,$template,$args) = @_;
	
	my $context = Context->new($this->options);
	my $layout = delete $args->{layout} || $this->layout;
	
	return $context->invoke_environment(
		sub {
			my $ctx = shift;
			if ($layout) {
				return $ctx->invoke_environment(
					sub {
						return shift->render(
							$layout,
							hashMerge(
								$args,
								{
									content => sub {
										$ctx->invoke_environment(
											sub {
												return shift->display_model($model,$template,$args);
											},
											{
												base => $this->viewBase
											}
										)
									}
								}
							)
						); # render
					},
					{
						base => $this->layoutBase,
					}
				);
			} else {
				return $ctx->invoke_environment(
					sub {
						return shift->display_model($model,$template,$args);
					},
					{
						base => $this->viewBase
					}
				);
			}
		},hashMerge(
			{
				includes => scalar($this->includes),
				tt_ext => $this->tt_ext,
				document => {},
				debug => sub {
					warn @_;
				}
			},
			$this->globals
		)
	);
}

1;