package IMPL::require;
use Scalar::Util qw(set_prototype);
use strict;
require IMPL::Code::Loader;

sub import {
	my ($self, $aliases) = @_;
	
	return unless $aliases;
	
	die "A hash reference is required" unless ref $aliases eq 'HASH';
	
	my $caller = caller;
	
	no strict 'refs';
	
	while( my ($alias, $class) = each %$aliases ) {
	    _require($class);
		
		*{"${caller}::$alias"} = set_prototype(sub {
            $class
        }, '');
	}
}

sub _require {
    my ($class) = @_;

    if ( not $class =~ s/^-// ) {
        ( my $file = $class ) =~ s/::|'/\//g;
        require "$file.pm";
    }
    $class;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::require> загружает и назначет псевдонимы модулям.

=head1 SYNOPSIS

=begin code

use IMPL::require {
	TFoo => 'My::Nested::Package::Foo',
	FS => 'File::Spec'
};

my $obj = My::Nested::Package::Foo->new('foo');
$obj = TFoo->new('foo'); # ditto

FS->catdir('one','two','three');

=end code

=head1 DESCRIPTION

Загружает модули с помощью C<require> и создает константы которые возвращаю полное имя модуля.


=cut