package IMPL::Web::Application::ResourceInterface;
use strict;

use IMPL::require {
    Exception => 'IMPL::Exception',
    NotImplException => '-IMPL::NotImplementedException'
};

sub InvokeHttpVerb {
    die NotImplException->new();
}

sub FetchChildResource {
    die NotImplementedException->new();
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Application::ResourceInterface> - Интерфейс для Web-ресурса.

=head1 SYNOPSIS

=begin code

package MyApp::Web::Resource;
use IMPL::Const qw(:prop);
use IMPL::declare {
    require => {
        NotAllowedException => 'IMPL::Web::NotAllowedException'        
    },
    base => [
        'IMPL::Object' => undef,
        'IMPL::Web::Application::ResourceInterface' => undef
    ],
    props => [
        model => PROP_ALL
    ]    
};

sub InvokeHttpVerb {
    my ($this,$verb,$action) = @_;
    
    if($verb eq 'GET') {
        return $this->model;
    } else {
        die NotAllowedException->new(allow => 'GET');
    }
}

sub FetchChildResource {
    # no child resources
    return;
}

=end code

=head1 DESCRIPTION

Данный модуль объявляет только интерфейс, тоесть в нем есть заглушки для функций
которые необходимо реализовать.

Для создания класса, который может быть использоваться для создания Web-ресурсов
нужно унаследовать данный интерфейс и реализовать его методы.

=head1 MEMBERS

=head2 C<InvokeHttpVerb($verb,$action)>

Выполняет операцию над ресурсом и возвращает результат ее выполнения.
Результатом может быть произвольный объект, который будет передан по цепочке
обработчиков приложения для формирования ответа вервера, либо
C<IMPL::Web::HttpResponse>, который описывает (не обязательно полностью) ответ.
В любом случае результат будет передан далее в цепочку обработчиков и может
быть изменен.  

=head2 C<FetchChildResource($childId)>

Используется для получения дочернего ресурса (который содержится в данном
контейнере). Метод должен возвращать либо Web-ресурс
C<IMPL::Web::Application::ResourceInterface>, либо C<undef> если дочерний ресурс
не найден.

=cut