package IMPL::Web::Handler::JSONView;
use strict;
use JSON;

use IMPL::declare {
    require => {
        HttpResponse => 'IMPL::Web::HttpResponse'        
    },
	base => [
		'IMPL::Object' => undef,
		'IMPL::Object::Serializable' => undef,
		'IMPL::Object::Autofill' => '@_'
	]
};

sub contentType {
	'application/json'
}

sub Invoke {
	my ($this,$action,$next) = @_;
	
	my $result = $next ? $next->($action) : undef;
	$result = [$result] unless ref $result;
	
	$action->response->contentType($this->contentType);
    
    return HttpResponse->new({
        type => $this->contentType,
        charset => 'utf-8',             
        body => JSON->new->utf8->pretty->encode($result)
    });
}

1;

__END__

=pod

=head1

=cut