package IMPL::Web::QueryHandler::PageFormat;
use base qw(IMPL::Web::QueryHandler IMPL::Object::Autofill);

__PACKAGE__->PassThroughArgs;

use IMPL::Class::Property;
use IMPL::Web::TDocument;
use Error qw(:try);

BEGIN {
	public property charsetTemplates => prop_all;
}

sub CTOR {
	my ($this) = @_;
	
	$this->charsetTemplates('utf-8') unless $this->charsetTemplates;
}

sub Process {
	my ($this,$action,$nextHandler) = @_;
	
	my $doc = new IMPL::Web::TDocument();
	
	try {
		$doc->loadFile ( $ENV{PATH_TRANSLATED}, $this->charsetTemplates );
		
		$action->response->contentType('text/html');
		my $hOut = $action->response->streamBody;
		
		print $hOut $doc->Render();
	} finally {
		$doc->Dispose;
	};
}

1;