package IMPL::Web::Application::Action;
use strict;

use base qw(IMPL::Object IMPL::Object::Autofill);

__PACKAGE__->PassThroughArgs;

use IMPL::Class::Property;

BEGIN {
	public property application => prop_get | owner_set;
	public property query => prop_get | owner_set;
	public property response => prop_get | owner_set;
	
	private property _entryPoint => prop_all;
}

#todo: make ability to discard old and create new response

sub Invoke {
	my ($this) = @_;
	
	if ($this->_entryPoint) {
		$this->_entryPoint->();
	} else {
		die new IMPL::InvalidOperationException("At least one handler is required");
	}
}

sub ChainHandler {
	my ($this,$handler) = @_;
	
	my $delegateNext = $this->_entryPoint();
	
	if (ref $handler eq 'CODE') {
		$this->_entryPoint( sub {
			$handler->($this,$delegateNext);			
		} );
	} elsif (ref $handler and UNIVERSAL::isa($handler,'IMPL::Web::QueryHandler')) {
		$this->_entryPoint( sub {
			$handler->Invoke($this,$delegateNext);
		} );
	} elsif ($handler and not ref $handler) {
		
		if (my $method = $this->can($handler) ) {
			$this->_entryPoint( sub {
				$method->($this,$delegateNext);			
			} );
		} else {
			{
				no strict 'refs';
				eval "require $handler; 1;" or die new IMPL::InvalidArgumentException("An invalid handler supplied",$handler,"Failed to load module") unless keys %{"${handler}::"};
			}
			
			if (UNIVERSAL::isa($handler,'IMPL::Web::QueryHandler')) {
				$this->_entryPoint( sub {
					$handler->Invoke($this,$delegateNext);
				} );	
			} else {
				die new IMPL::InvalidArgumentException("An invalid handler supplied",$handler);
			}
		}
	} else {
		die new IMPL::InvalidArgumentException("An invalid handler supplied",$handler);
	}
	
}

1;

__END__

=pod

=head1 DESCRIPTION

   .

     ,   
  .

    ,   

SecCallToMethod($target,$method)
AuthenticateMethod
TDocumentOut($file)

    

Action->Invoke() {
	TDocumentOut->Invoke($Action,$nextHandler) {
		my $result = $nextHandler() {
			$AuthenticateMethod($Action,$nextHandler) {
				my $context = $Action->application->security->Authenticate($Action->query,$Action->response);
				return $context->Impersonate($nextHandler) {
					$objSecCallToMethod->Invoke($Action,undef) {
						IMPL::Security->AccessCheck($target,$method);
						return $target->$method();
					}
				}
			}
		}
		$this->format($result,$Action->response->streamBody);
	}		
}

     

$objSecCallToMethod($target,$method)
$AuthenticateMethod
$TransfromToSimpleData
$JSONOut

      ,     
     JSON .    
     ,     .

=head1 HANDLERS

=head2 subroutines

=over

=item CODE ref

     ,      
 :   action ,     .

=item Method Name

 ,    .    action   
 ,           
:   action ,     .

    C<< $action->MethodName($nextHandler) >>; 

=back 

=head2 C< IMPL::Web::Application::QueryHandler >

    C< IMPL::Web::Application::QueryHandler >  
    

=cut