#!/usr/bin/perl -w
use strict;

use Pod::POM;
use Pod::POM::View::HTML;
use File::Spec;

our $LibDir = '../Lib/IMPL';
our $OutDir = 'html';

our $index = { name => 'root' };

sub process_file {
    my ($fname,@path) = @_;
    
    (my $name = $path[$#path]) =~ s/\.pm$//;
    
    (my $fileUrl = File::Spec->catfile(@path)) =~ s/\.pm$/.html/i;
    
    $index->{items}{$name}{name} = $name;
    $index->{items}{$name}{url} = $fileUrl;
    
    (my $fnameOut = File::Spec->catfile($OutDir,@path)) =~ s/\.pm$/.html/i;
    
    my $dir =$OutDir;
    foreach my $part (@path[0..$#path-1]) {
    	$dir = File::Spec->catdir($dir,$part);
    	mkdir $dir unless -d $dir;
    }
    
    open my $hPod, "<:encoding(cp1251)", $fname or die "Failed to open $fname for input: $!";
    open my $hOut, ">:encoding(utf-8)", $fnameOut or die "Failed to open $fnameOut for output: $!";
    
    my $parser = Pod::POM->new( );
    
    my $pom = $parser->parse_file($hPod);
    
    print $hOut PodViewHTML->print($pom);
}

sub process_dir {
    my ($dirname,@dirs) = @_;
    
    opendir my $hdir, $dirname or die "faield to open dir $dirname: $!";
    
    foreach my $entry (readdir $hdir) {
		next if grep $_ eq $entry, '.','..';
		
		my $path = "$dirname/$entry";
		
		print "$path";
		
		if (-d $path) {
		    print "\n";
		    local $index = exists $index->{items}{$entry} ? $index->{items}{$entry} : ($index->{items}{$entry} = {name => $entry});
		    process_dir($path,@dirs,$entry);
		} elsif ($entry =~ /\.(pm|pod)$/) {
		    print "\tprocessed\n";
		    process_file($path,@dirs,$entry);
		} else {
		    print "\tskipped\n";
	    }
    }
}

sub build_index {
	my ($hout,$index) = @_;
	
	print $hout "\n<ul>\n";
	
	if ($index->{items}) {
		foreach my $itemKey (sort keys %{$index->{items}}) {
			my $item = $index->{items}{$itemKey};
			print $hout "<li>";
			print $hout "<a href='$item->{url}'>" if $item->{url};
			print $hout $item->{name};
			print $hout "</a>" if $item->{url};
			build_index($hout,$item) if $item->{items};
			print $hout "</li>\n";
		}
	}
	
	print $hout "</ul>\n";
}

`rm -r html`;
mkdir 'html' unless -d 'html';

process_dir($LibDir);

open my $hout, ">:encoding(utf-8)", "$OutDir/index.html" or die "failed to open index.html for output: $!";

print $hout <<HEADER;
<html>
<head>
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<title>IMPL reference</title>
</head>
<body>
HEADER

build_index($hout,$index);

print $hout <<FOOTER;
</body>
</html>
FOOTER

package PodViewHTML;
use base qw(Pod::POM::View::HTML);

sub view_pod {
    my ($self, $pod) = @_;
    return "<html>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
    \n<body bgcolor=\"#ffffff\">\n"
 	. $pod->content->present($self)
        . "</body>\n</html>\n";
}
sub view_begin {
	my ($self,$begin) = @_;
	$begin->format =~ /code/i ? return "<pre>\n".join ("",$begin->text())."</pre>\n" : return $self->SUPER::view_begin($begin); 
}

sub view_seq_link {
	my ($self,$text) = @_;
	
	$text->text =~ /(?:(\w+)\s+)(\w+(?:\:\:\w+)*)/;
	
	
}