package Engine::Action::URICall;
use strict;
use Common;
use Engine::Action;

our $Namespace;

our %MapOutput;
our $DefaultMethod;

%MapOutput = ( page => 'Engine::Output::Page' , xml => 'Engine::Output::Xml' ) if not %MapOutput;

=pod
    /module/submodule/method.format
=cut

sub ConstructAction {
    my ($class,$uriRequest) = @_;
    
    my @module = $uriRequest->path_segments;

    my ($function,$format) = (((pop @module) or $DefaultMethod) =~ m/^(.*?)(?:\.(\w+))?$/);
    @module = grep $_, @module;
    my $module = @module ? ($Namespace ? $Namespace . '::' : '').join('::',@module) : $Namespace;
    
    return new Engine::Action( Package => $module, Method => $function, Output => $class->MapOutput($format), RequestURI => $uriRequest);
}

sub MapOutput {
    my ($class,$format) = @_;
    my $module = $MapOutput{$format} or return undef;
    
    eval "require $module;" or die new Exception('Failed to load output module',$module,$@);
    
    if ($module->can('construct')) {
        return $module->construct($format);
    } else {
        return $module;
    }
}

1;
