package Engine;
our $Encoding;

package Engine::Output::Template;
use strict;
use Common;
use Template;
our @ISA = qw(Object);
our %Formats;

BEGIN {
    DeclareProperty Include => ACCESS_READ;
    DeclareProperty ContentType => ACCESS_READ;
    DeclareProperty Encoding => ACCESS_READ;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$Include} = $args{Include} or die new Exception('An include diretory is required',$args{Format});
    $this->{$ContentType} = $args{ContentType} or die new Exception('A content type must be specied',$args{Format});
    $this->{$Encoding} = $args{Encoding};
}

sub Print {
    my ($this,$Query,$Action) = @_;
    
    my $template = new Template(
        {
            INCLUDE_PATH => $this->{$Include},
            INTERPOLATE => 1,
            RECURSION => 1,
            ENCODING => $this->{$Encoding}
        }
    );
    
    my @path = $Action->RequestURI->path_segments;
    shift @path;
    my $Template;
    eval {
        $Template = $template->context->template(join('/',@path));
    };
    print $Query->header(-type => 'text/html') and die new Exception('Failed to process a template', $@) if $@;
    $Query->Expires($Template->Expires);
    print $Query->header(-type => $this->{$ContentType});
    print $template->context->process($Template,{Encoding => $Engine::Encoding, Data => $Action->Result, Query => $Query });
}

sub construct {
    my ($class,$format) = @_;
    
    $class->new(%{$Formats{$format}},Format => $format);
}

1;