use strict;
package Security;

use constant {
    AUTH_FAILED =>      0,
    AUTH_SUCCESS =>     1,
    AUTH_INCOMPLETE =>  2,
    AUTH_NOAUTH =>      3
};

my $CurrentSession;

sub CurrentSession {
    my ($class,$newSession) = @_;
    
    $CurrentSession = $newSession if @_>=2;
    return $CurrentSession;
}

package Security::AuthResult;
use Common;
our @ISA = qw(Object);

BEGIN {
    DeclareProperty State => ACCESS_READ;
    DeclareProperty Session => ACCESS_READ;
    DeclareProperty ClientSecData => ACCESS_READ;
    DeclareProperty AuthMod => ACCESS_READ;
}

sub isSuccess {
    my ($this) = @_;
    return $this->{$State} == Security::AUTH_SUCCESS;
}


1;

