#!/usr/bin/perl -w
use strict;
use lib '..\Lib';

require IMPL::DOM::Navigator::SimpleBuilder;
require IMPL::DOM::XMLReader;

my $builder = IMPL::DOM::Navigator::SimpleBuilder->new();
    
    use Time::HiRes qw(gettimeofday tv_interval);
    
    my $t = [gettimeofday];
    
    $builder->NavigateCreate('personInfo', version => '1');
        $builder->NavigateCreate('firstName')->nodeValue('Nemo');
        $builder->Back();
        $builder->NavigateCreate('lastName')->nodeValue('Nobel');
        $builder->Back();
        $builder->NavigateCreate('lastName')->nodeValue('Gardum');
        $builder->Back();
        for(my $i = 0 ; $i < 10000; $i++) {
            $builder->NavigateCreate('address', local => 1);
                $builder->NavigateCreate('street')->nodeValue('Hellroad');
                $builder->Back();
                $builder->NavigateCreate('line')->nodeValue($_);
                $builder->Back();
            $builder->Back();
        }
    $builder->Back();
    
    print "Build: ",tv_interval($t,[gettimeofday]),"\n";
    
    $t = [gettimeofday];
    
    my $doc = new IMPL::DOM::Document(nodeName => 'doc');
    for(my $i = 0 ; $i < 30000; $i++) {
        my $node = new IMPL::DOM::Node(nodeName => 'test');
        $node->nodeValue(100);
        $doc->appendChild($node);
    }
    
    print "Create 30000 nodes: ",tv_interval($t,[gettimeofday]),"\n";
    
    $t = [gettimeofday];
    $builder = IMPL::DOM::Navigator::SimpleBuilder->new();
    my $reader = IMPL::DOM::XMLReader->new( Navigator => $builder );
    
    $reader->ParseFile("Resources/large.xml");
    print "Parsing large Xml file: ",tv_interval($t,[gettimeofday]),"\n";
    
    my $count = selectAll($builder->Document);
    my $len = length $builder->Document->text;
    print "Total nodes loaded: $count, data length: $len\n";
    
    $t = [gettimeofday];
    $builder = IMPL::DOM::Navigator::SimpleBuilder->new();
    my $reader2 = IMPL::DOM::XMLReader->new( Navigator => $builder );
    
    $reader2->ParseFile("Resources/person_info.xml");
    print "Parsing small Xml file: ",tv_interval($t,[gettimeofday]),"\n";
    
sub selectAll {
    my $node = shift;
    $node,map selectAll($_),@{$node->childNodes};
}
