package IMPL::DOM::Schema::SimpleType;
use strict;
use warnings;

use parent qw(IMPL::DOM::Schema::SimpleNode);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use IMPL::DOM::Property qw(_dom);

BEGIN {
    public _dom _direct property nativeType => prop_get;
    public _dom _direct property messageWrongType => prop_get;
}

our %CTOR = (
    'IMPL::DOM::Schema::SimpleNode' => sub {
        my %args = @_;
        $args{nodeName} = 'SimpleType';
        $args{minOccur} = 0;
        $args{maxOccur} = 'unbounded';
        $args{name} ||= 'SimpleType';
        delete @args{qw(nativeType messageWrongType)};
        %args
    }
);

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$nativeType} = $args{nativeType} if $args{nativeType};
    $this->{$messageWrongType} = $args{messageWrongType} || "A simple node '%Node.path%' is expected to be %Schema.nativeType%"; 
}

sub Validate {
    my ($this, $node, $ctx) = @_;
    
    if ($this->{$nativeType}) {
        return new IMPL::DOM::Schema::ValidationError(
            Node => $node,
            Source => $ctx && $ctx->{Source} || $this,
            Schema => $this,
            Message => $this->messageWrongType
        ) unless $node->isa($this->{$nativeType});
    }
    return $this->SUPER::Validate($node,$ctx);
}

sub qname {
    $_[0]->nodeName.'[type='.$_[0]->type.']';
}

1;

__END__

=pod

=head1 NAME

C<IMPL::DOM::Schema::SimpleType> - тип для простых узлов.

=head1 DESCRIPTION

Используется для описания простых узлов, которые можно отобразить в узлы
определенного типа при построении DOM документа.

=head1 MEMBERS

=over

=item C<nativeType>

Имя класса который будет представлять узел в DOM модели.

=item C<messageWrongType>

Формат сообщения которое будет выдано, если узел в дом модели не будет
соответствовать свойству C<nativeType>.

=back

=cut
