package IMPL::Object::Singleton;
use strict;
use warnings;

my %instances;

sub CTOR {
    die new IMPL::InvalidOperationException("Only one instance of the singleton can be created",ref $_[0], $instances{ref $_[0]}) if $instances{ref $_[0]};
    $instances{ref $_[0]} = $_[0];
}

sub instance {
    $instances{$_[0]}
}

1;

__END__

=pod

=head1 SYNOPSIS

=begin code

package Foo;

use parent qw(IMPL::Object IMPL::Object::Singleton);

#....

Foo->isnatnce->some_work();

Foo->isnatnce->get_result();

=end code

=head1 DESCRIPTION

Реализует шаблон Singleton

=head1 MEMBERS

=head2 OPERATORS

=list

=item C<instance CLASS(@params)>

Создает или возвращает экземпляр класса, если экземляр не существует, то он создается с параметрами C<@params>.

=over

=cut
