package IMPL::Web::CGIWrapper;
use strict;

use parent qw(CGI);
use Encode;

our $NO_DECODE = 0;

sub param {
    my $this = shift;

    return $this->SUPER::param(@_) if $NO_DECODE;

    if (wantarray) {
        my @result = $this->SUPER::param(@_);

        return map Encode::is_utf8($_)
          ? $_
          : Encode::decode( $this->charset, $_, Encode::LEAVE_SRC ), @result;
    }
    else {
        my $result = $this->SUPER::param(@_);

        return Encode::is_utf8($result)
          ? $result
          : Encode::decode( $this->charset, $result, Encode::LEAVE_SRC );
    }

}

sub upload {
    my $this = shift;

    local $NO_DECODE = 1;
    my $oldCharset = $this->charset();
    $this->charset('ISO-8859-1');

    my $fh = $this->SUPER::upload(@_);

    $this->charset($oldCharset);
    return $fh;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::CGIWrapper> - обетрка вокруг стандартного объекта C<CGI>

=head1 DESCRIPTION

Наследуется от C<CGI>, и переопределяет метод C<param> для декодирования
строковых параметров. В остальном функциональность аналогична стандартному
модулю C<CGI>.

=head1 MEMBERS

=head2 C<$NO_DECODE>

Глобальная переменная для отключения декодирования параметров.

=begin code

{
    local $IMPL::Web::CGIWrapper::NO_DECODE = 1;
    my $raw = $q->param('binary');
}

=end code 

=cut