package IMPL::Web::QueryHandler::SecureCookie;

use base qw(IMPL::Web::QueryHandler);
use Digest::MD5 qw(md5_hex);

use IMPL::Class::Property;
use IMPL::Security::Auth qw(:Const);

BEGIN {
	public property salt => prop_all;
}

sub CTOR {
	my ($this) = @_;
	
	
}

sub Process {
	my ($this,$action,$nextHandler) = @_;
	
	my $method = $action->query->cookie('method') || 'simple';
	
	if ($method eq 'simple') {
		
		my $sid = $action->query->cookie('sid'); 
		
		if ($action->query->cookie('sign') eq md5_hex(
			$this->salt,
			$sid,
			$this->salt
		) ) {
			
			my $context = $action->application->security->Session(
				id => $sid				
			);
			
			my ($result,$challenge) = $context->auth->ValidateSession($sid);
			
			if ($result == AUTH_SUCCESS) {
				return $context->Impersonate($nextHandler);				
			} else {
				return $nextHandler->();
			}
		}
	} else {
		die new IMPL::Exception("Unknown auth method",$method);
	}
}


1;