package IMPL::Web::View::TTRegistry;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
    require => {
        TTFactory => 'IMPL::Web::View::TTFactory'        
    },
    base => [
        'IMPL::Object' => undef
    ],
    props => [
        loader => PROP_RW,
        context => PROP_RW,
        _cache => PROP_RW,
    ]
};

sub Require {
    my ($this,$name) = @_;
    
    if(my $factory = $this->_cache->{$name}) {
        return $factory;
    } else {
        my $template = $this->loader->template($name)
            or die AppException->new("Failed to load a template $name");
         
        $factory = TTFactory->new(
            $template,
            $this->context,
            $name,
            $this
        );
        
        $this->_cache->{$name} = $factory;
        return $factory;
    }
}

1;

__END__
