package IMPL::Web::RestContract;
use strict;

use IMPL::lang qw(:declare :constants);
use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		InvalidOpException => '-IMPL::InvalidOperationException',
		ForbiddenException => 'IMPL::Web::ForbiddenException',
		TRestResource => 'IMPL::Web::Application::RestResource',
	},
	base => {
		'IMPL::Transform' => sub { my %args = @_; $args{resources} },
		'IMPL::Object::Serializable' => undef
	}
};

sub CTOR {
	my ($this) = @_;
	
	$this->templates->{-plain} = sub { die ForbiddenException->new(); };
	$this->templates->{-default} = sub { die ForbiddenException->new(); };
	$this->templates->{TRestResource} = sub { $_[0] };
}

sub ProcessTemplate {
	my ($this,$t,$obj,@args) = @_;
	
	if (ref $t eq 'HASH') {
		my $factory = $t->{factory} || TRestResource;
		return $factory->new(%$t, target => $obj);
	} elsif (ref $t eq 'CODE') {
		return $this->$t($obj,@args);
	} else {
		die InvalidOpException->new();
	}
}



1;

__END__

=pod

=head1 NAME

C<IMPL::Web::RestContract> Описывает правила публикации ресурсов.

=head1 SYNOPSIS

=begin code

=end code 

=cut